/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class RenameUtil
extends ContextAwareBase {
    static String RENAMING_ERROR_URL = "http://logback.qos.ch/codes.html#renamingError";
    static final int BUF_SIZE = 32768;

    public void rename(String from2, String to2) throws RolloverFailure {
        if (from2.equals(to2)) {
            this.addWarn("From and to file are the same [" + from2 + "]. Skipping.");
            return;
        }
        File fromFile2 = new File(from2);
        if (fromFile2.exists()) {
            File toFile = new File(to2);
            this.createMissingTargetDirsIfNecessary(toFile);
            this.addInfo("Renaming file [" + fromFile2 + "] to [" + toFile + "]");
            boolean result2 = fromFile2.renameTo(toFile);
            if (!result2) {
                this.addWarn("Failed to rename file [" + fromFile2 + "] to [" + toFile + "].");
                this.addWarn("Please consider leaving the [file] option of " + RollingFileAppender.class.getSimpleName() + " empty.");
                this.addWarn("See also " + RENAMING_ERROR_URL);
            }
        } else {
            throw new RolloverFailure("File [" + from2 + "] does not exist.");
        }
    }

    public void renameByCopying(String from2, String to2) throws RolloverFailure {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int n;
            bis = new BufferedInputStream(new FileInputStream(from2));
            bos = new BufferedOutputStream(new FileOutputStream(to2));
            byte[] inbuf = new byte[32768];
            while ((n = bis.read(inbuf)) != -1) {
                ((BufferedOutputStream)bos).write(inbuf, 0, n);
            }
            bis.close();
            bis = null;
            bos.close();
            bos = null;
            File fromFile2 = new File(from2);
            if (!fromFile2.delete()) {
                this.addWarn("Could not delete " + from2);
            }
        }
        catch (IOException ioe) {
            this.addError("Failed to rename file by copying", ioe);
            throw new RolloverFailure("Failed to rename file by copying");
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    void createMissingTargetDirsIfNecessary(File toFile) throws RolloverFailure {
        boolean result2;
        if (FileUtil.isParentDirectoryCreationRequired(toFile) && !(result2 = FileUtil.createMissingParentDirectories(toFile))) {
            throw new RolloverFailure("Failed to create parent directories for [" + toFile.getAbsolutePath() + "]");
        }
    }

    public String toString() {
        return "c.q.l.co.rolling.helper.RenameUtil";
    }
}

